/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeLand;
import com.lycanitesmobs.desertmobs.CommonSubProxy;
import com.lycanitesmobs.desertmobs.dispenser.DispenserBehaviorMudshot;
import com.lycanitesmobs.desertmobs.dispenser.DispenserBehaviorThrowingScythe;
import com.lycanitesmobs.desertmobs.entity.EntityClink;
import com.lycanitesmobs.desertmobs.entity.EntityCrusk;
import com.lycanitesmobs.desertmobs.entity.EntityCryptZombie;
import com.lycanitesmobs.desertmobs.entity.EntityErepede;
import com.lycanitesmobs.desertmobs.entity.EntityGorgomite;
import com.lycanitesmobs.desertmobs.entity.EntityJoust;
import com.lycanitesmobs.desertmobs.entity.EntityJoustAlpha;
import com.lycanitesmobs.desertmobs.entity.EntityManticore;
import com.lycanitesmobs.desertmobs.entity.EntityMudshot;
import com.lycanitesmobs.desertmobs.entity.EntitySutiramu;
import com.lycanitesmobs.desertmobs.entity.EntityThrowingScythe;
import com.lycanitesmobs.desertmobs.item.ItemDesertEgg;
import com.lycanitesmobs.desertmobs.item.ItemMudshotCharge;
import com.lycanitesmobs.desertmobs.item.ItemScepterMudshot;
import com.lycanitesmobs.desertmobs.item.ItemScepterScythe;
import com.lycanitesmobs.desertmobs.item.ItemThrowingScythe;
import com.lycanitesmobs.desertmobs.mobevent.MobEventMarchOfTheGorgomites;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="desertmobs", name="Lycanites Desert Mobs", version="1.17.1.2 - MC 1.10.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.10.2]")
public class DesertMobs {
    public static final String modid = "desertmobs";
    public static final String name = "Lycanites Desert Mobs";
    public static GroupInfo group;
    @Mod.Instance(value="desertmobs")
    public static DesertMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.desertmobs.ClientSubProxy", serverSide="com.lycanitesmobs.desertmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        group = new GroupInfo(this, "Desert Mobs", 4).setDimensionBlacklist("-1,1").setBiomes("SANDY, WASTELAND, MESA, -COLD").setDungeonThemes("DESERT, WASTELAND, NECRO").setEggName("desertspawn");
        group.loadFromConfig();
        ObjectManager.setCurrentGroup(group);
        ObjectManager.addItem("desertspawn", new ItemDesertEgg());
        ObjectManager.addItem("throwingscythe", new ItemThrowingScythe());
        ObjectManager.addItem("joustmeatraw", (Item)new ItemCustomFood("joustmeatraw", group, 2, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76421_d, 45, 2, 0.8f));
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("joustmeatraw"));
        OreDictionary.registerOre((String)"listAllchickenraw", (Item)ObjectManager.getItem("joustmeatraw"));
        ObjectManager.addItem("joustmeatcooked", (Item)new ItemCustomFood("joustmeatcooked", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setPotionEffect(MobEffects.field_76424_c, 10, 2, 1.0f).setAlwaysEdible());
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("joustmeatcooked"));
        OreDictionary.registerOre((String)"listAllchickencooked", (Item)ObjectManager.getItem("joustmeatcooked"));
        ObjectManager.addItem("ambercake", new ItemCustomFood("ambercake", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setPotionEffect(MobEffects.field_76424_c, 60, 2, 1.0f).setAlwaysEdible().func_77625_d(16), 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("ambercake"));
        ObjectManager.addItem("crusktreat", new ItemTreat("crusktreat", group));
        ObjectManager.addItem("erepedetreat", new ItemTreat("erepedetreat", group));
        ObjectManager.addItem("mudshotcharge", new ItemMudshotCharge());
        ObjectManager.addItem("scythescepter", new ItemScepterScythe(), 2, 1, 1);
        ObjectManager.addItem("mudshotscepter", new ItemScepterMudshot(), 2, 1, 1);
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("desertspawn"), (Object)new DispenserBehaviorMobEggCustom());
        MobInfo newMob = new MobInfo(group, "cryptzombie", EntityCryptZombie.class, 0xCC9966, 0xAA8800).setPeaceful(false).setSummonCost(2).setDungeonLevel(0).addSubspecies(new Subspecies("scarlet", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(8).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "sutiramu", EntitySutiramu.class, 8607035, 2890767).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(0).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("scarlet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(8).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "crusk", EntityCrusk.class, 0xFFDDAA, 0).setPeaceful(false).setTameable(true).setSummonCost(8).setDungeonLevel(2).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("light", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(2).setAreaLimit(3).setGroupLimits(1, 1).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "clink", EntityClink.class, 0xFFAAAA, 0x999999).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("ashen", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(6).setAreaLimit(10).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "joust", EntityJoust.class, 0xFF9900, 0xFFFF00).setPeaceful(true).setSummonCost(2).setDungeonLevel(-1).addSubspecies(new Subspecies("russet", "uncommon")).addSubspecies(new Subspecies("light", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("CREATURE").setDespawn(false).setSpawnWeight(10).setAreaLimit(10).setGroupLimits(1, 5).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "joustalpha", EntityJoustAlpha.class, 0xFF0000, 0xFFFF00).setPeaceful(false).setSummonCost(4).setDungeonLevel(2).addSubspecies(new Subspecies("verdant", "uncommon")).addSubspecies(new Subspecies("violet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("").setDespawn(false).setSpawnWeight(2).setAreaLimit(2).setGroupLimits(1, 2).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "erepede", EntityErepede.class, 0xDD9922, 0xFFDDFF).setPeaceful(false).setTameable(true).setSummonCost(6).setDungeonLevel(1).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("ashen", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "gorgomite", EntityGorgomite.class, 0xCC9900, 0x884400).setPeaceful(false).setSummonCost(1).setDungeonLevel(1).addSubspecies(new Subspecies("dark", "uncommon")).addSubspecies(new Subspecies("keppel", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(6).setAreaLimit(40).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "manticore", EntityManticore.class, 0x442200, 0x990000).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("golden", "uncommon")).addSubspecies(new Subspecies("scarlet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("SKY").setSpawnWeight(6).setAreaLimit(10).setGroupLimits(1, 5).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        ObjectManager.addProjectile("throwingscythe", EntityThrowingScythe.class, ObjectManager.getItem("throwingscythe"), new DispenserBehaviorThrowingScythe());
        ObjectManager.addProjectile("mudshot", EntityMudshot.class, ObjectManager.getItem("mudshotcharge"), new DispenserBehaviorMudshot());
        proxy.registerModels(group);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MobInfo.loadAllFromConfigs(group);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ObjectManager.setCurrentGroup(group);
        ConfigBase config = ConfigBase.getConfig(group, "spawning");
        MobEventMarchOfTheGorgomites mobEvent = new MobEventMarchOfTheGorgomites("marchofthegorgomites", group);
        mobEvent.minDay = 10;
        SpawnTypeBase eventSpawner = new SpawnTypeLand("marchofthegorgomites").setChance(1.0).setBlockLimit(32).setMobLimit(8);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("gorgomite"));
        mobEvent.addSpawner(eventSpawner);
        MobEventManager.instance.addWorldEvent(mobEvent);
        Biome[] biomes = DesertMobs.group.biomes;
        if (DesertMobs.group.controlVanillaSpawns) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("throwingscythe"), 17, 0), new Object[]{Items.field_151042_j, ObjectManager.getItem("throwingscythe")}));
        if (ItemInfo.enableWeaponRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("scythescepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("throwingscythe"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("mudshotscepter"), 1, 0), new Object[]{" C ", " R ", " R ", Character.valueOf('C'), ObjectManager.getItem("mudshotcharge"), Character.valueOf('R'), Items.field_151072_bj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("ambercake"), 1, 0), new Object[]{Items.field_151102_aT, new ItemStack(Items.field_151100_aR, 1, 2), ObjectManager.getItem("joustmeatcooked")}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("joustmeatcooked"), 1, 0), new Object[]{ObjectManager.getItem("ambercake")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("crusktreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("joustmeatcooked"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("erepedetreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Items.field_151043_k, Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addSmelting((Item)ObjectManager.getItem("joustmeatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("joustmeatcooked"), 1), (float)0.5f);
    }
}

